#!/bin/sh
TP_PING_RESULT_NULL="DTAS[TUI]@{NULL}"
TP_PING_RESULT_DATA=""

TP_PING_RESULT_OK="DTAS[TUI]@{OK}"
TP_PING_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_PING_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_PING_RESULT_CODE=""

TP_PING_RESULT_MSG=""

tp_ping() {
    #debug_print "${0}" "${LINENO}" 'in function "tp_ping"'
    
    local title="${1}"
    local text="${2}"
    local ok_label="${3}"
    local cancel_label="${4}"
    local init_text="${5}"

    exec 3>&1
    local ret
    ret=`dialog \
            --title        "${title}" \
            --backtitle    "${CONS_BACK_TITLE}" \
            --ok-label     "${ok_label}" \
            --cancel-label "${cancel_label}" \
            --inputbox     "${text}" \
                           "${CONS_BOX_HEIGHT}" \
                           "${CONS_BOX_WIDTH}" \
                           "${init_text}" \
            2>&1 1>&3; \
            case "${?}" in \
                1|255) echo "${TP_PING_RESULT_CANCEL}" ;; \
            esac`
    exec 3>&-
    
    ##################################################
    # press "CANCEL" or "ESC"
    ##################################################
    case "${ret}" in
        "${TP_PING_RESULT_CANCEL}" )
            TP_PING_RESULT_CODE="${TP_PING_RESULT_CANCEL}"
            TP_PING_RESULT_DATA="${TP_PING_RESULT_NULL}"
            TP_PING_RESULT_MSG=""
            return
            ;;
    esac

    if ! $(is_fqdn_valid "${ret}") ; then
      if ! $(is_ip_valid "${ret}") ; then
        if ! $(is_ipv6_address_valid "${ret}") ; then
		    #debug_print "${0}" "${LINENO}" "invalid IP/FQDN: ${ret}"
        
            TP_PING_RESULT_CODE="${TP_PING_RESULT_ERROR}"
            TP_PING_RESULT_MSG="${TP_PING_ERROR_INVALID_IP_FQDN}"
            TP_PING_RESULT_DATA="${ret}"
            return
        fi
      fi
    fi

    TP_PING_RESULT_CODE="${TP_PING_RESULT_OK}"
    TP_PING_RESULT_DATA="${ret}"
    TP_PING_RESULT_MSG=""
    return
}
 
